% Copyright (c) 2016 Giampaolo D'Alessandro
% Mathematical Sciences - University of Southampton
% Email: dales@soton.ac.uk
% 
% Permission is hereby granted, free of charge, to any person obtaining a copy
% of this software and associated documentation files (the "Software"), to deal
% in the Software without restriction, including without limitation the rights
% to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
% copies of the Software, and to permit persons to whom the Software is
% furnished to do so, subject to the following conditions:
% 
% The above copyright notice and this permission notice shall be included in
% all copies or substantial portions of the Software.
% 
% THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
% IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
% FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
% AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
% LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
% OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
% SOFTWARE.

% Scvript to plot fig 7 diffraction efficiency as a function of the pump
% intensity: experimental and numerical data.
I_exp = [3 12 18 19.5 22 23];           % From Experimental data
sqrt_eta_exp = 1e-3*[19.1 86.2 139.7 138.9 170.7 186];    % From Experimental Data

I_num = [1 24];                     % Input beam intensities
sqrt_eta_num = 1e-3*[6 172.4];      % \sqrt(DiffEff) calculated in the script Fig7a.m

FontName='Times';
FontSize=24;
FontAngle='normal'; %'italic';
LineWidth=2;
MarkerSize=12;  % In points (72 points per inch)

figure(9); clf;
set(gcf,'PaperOrientation','Landscape','PaperType','A4',...
  'PaperUnits','normalized','PaperPosition',[0 0 1 1]);
axes('Parent',gcf,...
  'YMinorTick','on','XMinorTick','on',...
  'FontSize',FontSize,'FontName',FontName,'FontAngle',FontAngle);
hold(gca,'all');
plot(I_exp,sqrt_eta_exp,'dr','MarkerSize',MarkerSize,...
  'DisplayName','Experiment','LineWidth',LineWidth);
plot(I_num,sqrt_eta_num,'b-','LineWidth',LineWidth,...
  'DisplayName','Theory');
xlabel('I_{pump} [W cm^{-2}]');
ylabel('\surd\eta');
legend(gca,'Location','SouthEast');
% title('Diffraction Efficiency vs Pump intensity');
% text(1,0.135,'\sigma_{pump}= 300\mum',...
%   'FontSize',FontSize,'FontName',FontName,'FontAngle',FontAngle);
% text(1,0.155,'Glass thickness = 500\mum',...
%   'FontSize',FontSize,'FontName',FontName,'FontAngle',FontAngle);
% text(1,0.175,'Glass therm. cond. = 1 W K^{-1} m^{-1}',...
%   'FontSize',FontSize,'FontName',FontName,'FontAngle',FontAngle);
saveas(gcf,'DiffEffInt','pdf');
saveas(gcf,'DiffEffInt','png');